//Falcon-180B DATASET v1.0 Category: Firewall ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_RULES 100
#define MAX_RULE_LENGTH 100

typedef struct {
    char source_ip[16];
    char dest_ip[16];
    char protocol[10];
    char action[10];
} rule_t;

int num_rules = 0;
rule_t rules[MAX_RULES];

void add_rule(char* source_ip, char* dest_ip, char* protocol, char* action) {
    if (num_rules >= MAX_RULES) {
        printf("Error: Maximum number of rules reached.\n");
        return;
    }

    strncpy(rules[num_rules].source_ip, source_ip, 16);
    strncpy(rules[num_rules].dest_ip, dest_ip, 16);
    strncpy(rules[num_rules].protocol, protocol, 10);
    strncpy(rules[num_rules].action, action, 10);

    num_rules++;
}

int is_allowed(char* source_ip, char* dest_ip, char* protocol) {
    int i;

    for (i = 0; i < num_rules; i++) {
        if (strcmp(rules[i].source_ip, source_ip) == 0 &&
            strcmp(rules[i].dest_ip, dest_ip) == 0 &&
            strcmp(rules[i].protocol, protocol) == 0 &&
            strcmp(rules[i].action, "allow") == 0) {
            return 1;
        }
    }

    return 0;
}

int main() {
    char source_ip[16] = "192.168.1.1";
    char dest_ip[16] = "192.168.1.2";
    char protocol[10] = "TCP";

    add_rule(source_ip, dest_ip, protocol, "allow");
    add_rule(source_ip, dest_ip, protocol, "deny");

    if (is_allowed(source_ip, dest_ip, protocol)) {
        printf("Connection allowed.\n");
    } else {
        printf("Connection denied.\n");
    }

    return 0;
}