//Falcon-180B DATASET v1.0 Category: Network Packet Monitoring ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <errno.h>

#define MAX_PACKET_SIZE 65535
#define SNAPLEN 65535
#define TRUE 1
#define FALSE 0

typedef struct {
    u_char *data;
    int size;
} Packet;

void process_packet(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    Packet *pkt = (Packet *) args;
    pkt->data = (u_char *) malloc(header->caplen);
    if (pkt->data == NULL) {
        fprintf(stderr, "Error: Memory allocation failed.\n");
        exit(1);
    }
    memcpy(pkt->data, packet, header->caplen);
    pkt->size = header->caplen;
}

int main(int argc, char **argv) {
    char *dev;
    char errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;
    Packet packet;

    if (argc!= 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        exit(1);
    }

    dev = argv[1];

    // Open device for capturing
    handle = pcap_open_live(dev, SNAPLEN, 1, 1000, errbuf);

    if (handle == NULL) {
        fprintf(stderr, "Error: %s\n", errbuf);
        exit(1);
    }

    // Set filter to capture all packets
    char filter_exp[] = "ip";
    if (pcap_compile(handle, &packet.data, filter_exp, 0, 0) == -1) {
        fprintf(stderr, "Error: %s\n", pcap_geterr(handle));
        exit(1);
    }

    // Set callback function to process packets
    pcap_loop(handle, 0, process_packet, &packet);

    // Close device
    pcap_close(handle);

    return 0;
}