//MISTRAL-7B DATASET v1.0 Category: Networking ; Style: detailed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <arpa/inet.h>
#include <sys/socket.h>

#define PORT 8080
#define BUFFER_SIZE 1024

int main(int argc, char const *argv[])
{
    int sock = 0, valread;
    struct sockaddr_in serv_addr;
    char *hello = "Hello from server";
    char buffer[BUFFER_SIZE] = {0};
    char *welcome = "Welcome to the server";

    if ((sock = socket(AF_INET, SOCK_STREAM, 0)) < 0)
    {
        perror("socket creation error");
        printf("Failed to create socket\n");
        return -1;
    }

    serv_addr.sin_family = AF_INET;
    serv_addr.sin_addr.s_addr = INADDR_ANY;
    serv_addr.sin_port = htons(PORT);

    if (bind(sock, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
    {
        perror("bind failed");
        perror("Error while binding");
        free(hello);
        return -1;
    }
    if (listen(sock, 3) < 0)
    {
        perror("listen");
        perror("Error in listening");
        free(hello);
        return -1;
    }

    printf("Waiting for incoming connection...\n");
    if ((valread = accept(sock, NULL, NULL)) < 0)
    {
        perror("accept");
        printf("Error occurred while accepting the client request\n");
        free(hello);
        return -1;
    }

    printf("Connection accepted\n");

    send(valread, welcome, strlen(welcome), 0);
    printf("Hello message sent\n");

    valread = read(valread, buffer, BUFFER_SIZE);
    printf("Client message: %s\n", buffer);

    send(valread, hello, strlen(hello), 0);
    printf("Hello message sent to client\n");

    free(hello);
    free(welcome);
    close(sock);

    return 0;
}