//Falcon-180B DATASET v1.0 Category: Memory management ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>

#define HEAP_SIZE 1000

typedef struct block {
    size_t size;
    bool free;
    struct block *next;
} Block;

Block *freeList = (void*)0;
char heap[HEAP_SIZE];

void init() {
    freeList = (Block*)heap;
    freeList->size = HEAP_SIZE - sizeof(Block);
    freeList->free = true;
    freeList->next = (void*)0;
}

void *malloc(size_t numBytes) {
    Block *current, *prev;
    void *result;

    current = freeList;
    while ((((current->size) < numBytes) || ((current->free) == false)) && (current!= freeList)) {
        prev = current;
        current = current->next;
    }

    if (current->size == numBytes) {
        current->free = false;
        result = (void*)(++current);
        return result;
    } else if (current->size > numBytes) {
        Block *newBlock = (void*)((void*)current + numBytes + sizeof(Block));
        newBlock->size = current->size - numBytes - sizeof(Block);
        newBlock->free = true;
        newBlock->next = current->next;
        current->size = numBytes;
        current->free = false;
        current->next = newBlock;
        result = (void*)(++current);
        return result;
    }

    return (void*)0;
}

void free(void* ptr) {
    if (ptr == (void*)0)
        return;

    Block* blk = (Block*)ptr;
    --blk;

    blk->free = true;
}

int main() {
    init();

    int* a = (int*)malloc(sizeof(int));
    *a = 42;

    int* b = (int*)malloc(sizeof(int));
    *b = 13;

    printf("a = %d, b = %d\n", *a, *b);

    free(a);
    free(b);

    return 0;
}