//Falcon-180B DATASET v1.0 Category: Interprocess communication ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>
#include <fcntl.h>
#include <string.h>

#define SIZE 1024

typedef struct {
    int num;
    char name[20];
} Data;

void write_to_pipe(int fd) {
    Data data;
    strcpy(data.name, "Neo");
    data.num = 42;
    write(fd, &data, sizeof(data));
}

void read_from_pipe(int fd) {
    Data data;
    read(fd, &data, sizeof(data));
    printf("Name: %s, Number: %d\n", data.name, data.num);
}

int main() {
    int fd[2];
    pid_t pid;

    if (pipe(fd) == -1) {
        printf("Pipe failed\n");
        exit(1);
    }

    pid = fork();

    if (pid < 0) {
        printf("Fork failed\n");
        exit(1);
    } else if (pid > 0) {
        close(fd[0]);
        write_to_pipe(fd[1]);
        close(fd[1]);
    } else {
        close(fd[1]);
        read_from_pipe(fd[0]);
        close(fd[0]);
    }

    return 0;
}