//GEMINI-pro DATASET v1.0 Category: Fitness Tracker ; Style: innovative
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

// Define the fitness tracker's data structure
typedef struct {
    int steps;
    int calories;
    int distance;
    int heart_rate;
    time_t timestamp;
} fitness_data;

// Define the fitness tracker's functions
void initialize_fitness_tracker(fitness_data *tracker);
void update_fitness_tracker(fitness_data *tracker, int steps, int calories, int distance, int heart_rate);
void print_fitness_tracker(fitness_data *tracker);

// Main function
int main() {
    // Create a fitness tracker
    fitness_data tracker;

    // Initialize the fitness tracker
    initialize_fitness_tracker(&tracker);

    // Update the fitness tracker with some sample data
    update_fitness_tracker(&tracker, 10000, 500, 5, 70);

    // Print the fitness tracker data
    print_fitness_tracker(&tracker);

    return 0;
}

// Function to initialize the fitness tracker
void initialize_fitness_tracker(fitness_data *tracker) {
    tracker->steps = 0;
    tracker->calories = 0;
    tracker->distance = 0;
    tracker->heart_rate = 0;
    tracker->timestamp = time(NULL);
}

// Function to update the fitness tracker
void update_fitness_tracker(fitness_data *tracker, int steps, int calories, int distance, int heart_rate) {
    tracker->steps += steps;
    tracker->calories += calories;
    tracker->distance += distance;
    tracker->heart_rate += heart_rate;
    tracker->timestamp = time(NULL);
}

// Function to print the fitness tracker data
void print_fitness_tracker(fitness_data *tracker) {
    printf("Steps: %d\n", tracker->steps);
    printf("Calories: %d\n", tracker->calories);
    printf("Distance: %d\n", tracker->distance);
    printf("Heart rate: %d\n", tracker->heart_rate);
    printf("Timestamp: %s\n", ctime(&tracker->timestamp));
}