//GPT-4o-mini DATASET v1.0 Category: Classical Circuit Simulator ; Style: scalable
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define MAX_COMPONENTS 100

// Enum for component types
typedef enum {
    RESISTOR,
    CAPACITOR,
    INDUCTOR,
    VOLTAGE_SOURCE,
    CURRENT_SOURCE
} ComponentType;

// Struct to represent a circuit component
typedef struct {
    ComponentType type;
    char name[10];
    double value; // Value of the component (Ohm, Farad, Henry, Volt, Amp)
} Component;

// Struct to represent the circuit
typedef struct {
    Component components[MAX_COMPONENTS];
    int componentCount;
} Circuit;

// Function to initialize a new circuit
void initCircuit(Circuit* circuit) {
    circuit->componentCount = 0;
}

// Function to add a component to the circuit
void addComponent(Circuit* circuit, ComponentType type, const char* name, double value) {
    if (circuit->componentCount < MAX_COMPONENTS) {
        circuit->components[circuit->componentCount].type = type;
        snprintf(circuit->components[circuit->componentCount].name, sizeof(circuit->components[circuit->componentCount].name), "%s", name);
        circuit->components[circuit->componentCount].value = value;
        circuit->componentCount++;
    } else {
        printf("Cannot add more components to the circuit.\n");
    }
}

// Function to display circuit components
void displayCircuit(const Circuit* circuit) {
    printf("Circuit Components:\n");
    for (int i = 0; i < circuit->componentCount; i++) {
        switch (circuit->components[i].type) {
            case RESISTOR:
                printf("Component %d: RESISTOR - %s (%f Ohm)\n", i + 1, circuit->components[i].name, circuit->components[i].value);
                break;
            case CAPACITOR:
                printf("Component %d: CAPACITOR - %s (%f F)\n", i + 1, circuit->components[i].name, circuit->components[i].value);
                break;
            case INDUCTOR:
                printf("Component %d: INDUCTOR - %s (%f H)\n", i + 1, circuit->components[i].name, circuit->components[i].value);
                break;
            case VOLTAGE_SOURCE:
                printf("Component %d: VOLTAGE SOURCE - %s (%f V)\n", i + 1, circuit->components[i].name, circuit->components[i].value);
                break;
            case CURRENT_SOURCE:
                printf("Component %d: CURRENT SOURCE - %s (%f A)\n", i + 1, circuit->components[i].name, circuit->components[i].value);
                break;
        }
    }
}

// Function to calculate the total resistance in series
double totalResistanceSeries(const Circuit* circuit) {
    double total = 0;
    for (int i = 0; i < circuit->componentCount; i++) {
        if (circuit->components[i].type == RESISTOR) {
            total += circuit->components[i].value;
        }
    }
    return total;
}

// Function to calculate the total capacitance in parallel
double totalCapacitanceParallel(const Circuit* circuit) {
    double total = 0;
    for (int i = 0; i < circuit->componentCount; i++) {
        if (circuit->components[i].type == CAPACITOR) {
            total += circuit->components[i].value;
        }
    }
    return total;
}

// Function to run the circuit simulation
void runSimulation(const Circuit* circuit) {
    double totalResistance = totalResistanceSeries(circuit);
    double totalCapacitance = totalCapacitanceParallel(circuit);

    printf("Simulation Results:\n");
    printf("Total Resistance (Series): %f Ohm\n", totalResistance);
    printf("Total Capacitance (Parallel): %f F\n", totalCapacitance);
}

int main() {
    Circuit circuit;
    initCircuit(&circuit);

    // Adding components
    addComponent(&circuit, RESISTOR, "R1", 100.0);
    addComponent(&circuit, CAPACITOR, "C1", 0.001);
    addComponent(&circuit, RESISTOR, "R2", 220.0);
    addComponent(&circuit, INDUCTOR, "L1", 0.1);
    addComponent(&circuit, VOLTAGE_SOURCE, "V1", 12.0);
    addComponent(&circuit, CURRENT_SOURCE, "I1", 0.5);

    // Display circuit components
    displayCircuit(&circuit);

    // Run simulation
    runSimulation(&circuit);

    return 0;
}