//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: light-weight
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_PROCESSES 5

typedef struct Process {
    int pid;
    int burst_time;
    int waiting_time;
    int turnaround_time;
} Process;

void simulate_cpu_scheduling(Process processes[]) {
    int i, j, quantum = 0, total_waiting_time = 0, total_turnaround_time = 0;

    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].waiting_time = 0;
        processes[i].turnaround_time = 0;
    }

    while (!processes[0].waiting_time) {
        for (i = 0; i < MAX_PROCESSES; i++) {
            if (processes[i].burst_time > quantum) {
                processes[i].waiting_time++;
                processes[i].burst_time -= quantum;
            } else {
                processes[i].waiting_time++;
                processes[i].burst_time = 0;
            }
        }

        quantum++;

        for (j = 0; j < MAX_PROCESSES; j++) {
            total_waiting_time += processes[j].waiting_time;
            total_turnaround_time += processes[j].turnaround_time;
        }
    }

    printf("Total Waiting Time: %d\n", total_waiting_time);
    printf("Total Turnaround Time: %d\n", total_turnaround_time);
}

int main() {
    Process processes[MAX_PROCESSES] = {
        {1, 5, 0, 0},
        {2, 3, 0, 0},
        {3, 4, 0, 0},
        {4, 2, 0, 0},
        {5, 6, 0, 0}
    };

    simulate_cpu_scheduling(processes);

    return 0;
}