//Code Llama-13B DATASET v1.0 Category: Cafe Billing System ; Style: safe
/*
 * A safe C Cafe Billing System example program
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Structure to store customer information
typedef struct {
    char name[50];
    int age;
    char email[100];
    int phone_number;
} customer_t;

// Structure to store menu items
typedef struct {
    char name[50];
    float price;
} menu_item_t;

// Function to calculate the total cost of an order
float calculate_total_cost(menu_item_t *menu_items, int num_items) {
    float total_cost = 0;
    for (int i = 0; i < num_items; i++) {
        total_cost += menu_items[i].price;
    }
    return total_cost;
}

// Function to print the order details
void print_order_details(customer_t *customer, menu_item_t *menu_items, int num_items) {
    printf("Customer Name: %s\n", customer->name);
    printf("Customer Age: %d\n", customer->age);
    printf("Customer Email: %s\n", customer->email);
    printf("Customer Phone Number: %d\n", customer->phone_number);
    printf("Menu Items:\n");
    for (int i = 0; i < num_items; i++) {
        printf("%s - $%.2f\n", menu_items[i].name, menu_items[i].price);
    }
    printf("Total Cost: $%.2f\n", calculate_total_cost(menu_items, num_items));
}

int main() {
    // Declare variables
    customer_t customer = { "John Doe", 25, "johndoe@email.com", 1234567890 };
    menu_item_t menu_items[3] = {
        { "Coffee", 2.50 },
        { "Tea", 1.50 },
        { "Sandwich", 5.00 }
    };
    int num_items = 3;

    // Print order details
    print_order_details(&customer, menu_items, num_items);

    return 0;
}