//GPT-4o-mini DATASET v1.0 Category: Database querying ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>
#include <sqlite3.h>

// Callback function to display query results
static int callback(void *data, int argc, char **argv, char **azColName) {
    int i;
    printf("%s:\n", (const char *)data);
    for (i = 0; i < argc; i++) {
        printf("  %s = %s\n", azColName[i], argv[i] ? argv[i] : "NULL");
    }
    printf("\n");
    return 0;
}

// Function to create a new table
void create_table(sqlite3 *db) {
    char *errMsg;
    const char *sql = "CREATE TABLE IF NOT EXISTS Students (" \
                      "ID INTEGER PRIMARY KEY AUTOINCREMENT," \
                      "Name TEXT NOT NULL," \
                      "Age INT NOT NULL," \
                      "Major TEXT NOT NULL);";

    if (sqlite3_exec(db, sql, 0, 0, &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL Error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Table created successfully\n");
    }
}

// Function to insert a new student
void insert_student(sqlite3 *db, const char *name, int age, const char *major) {
    char *errMsg;
    char sql[256];
    snprintf(sql, sizeof(sql), "INSERT INTO Students (Name, Age, Major) VALUES ('%s', %d, '%s');", name, age, major);

    if (sqlite3_exec(db, sql, 0, 0, &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL Error: %s\n", errMsg);
        sqlite3_free(errMsg);
    } else {
        printf("Student %s inserted successfully\n", name);
    }
}

// Function to query and display all students
void query_students(sqlite3 *db) {
    char *errMsg;
    const char *sql = "SELECT * FROM Students;";
    
    printf("Querying all students:\n");
    if (sqlite3_exec(db, sql, callback, (void *)"Result", &errMsg) != SQLITE_OK) {
        fprintf(stderr, "SQL Error: %s\n", errMsg);
        sqlite3_free(errMsg);
    }
}

int main(int argc, char* argv[]) {
    sqlite3 *db;
    char *errMsg;

    // Open the database
    if (sqlite3_open("school.db", &db) != SQLITE_OK) {
        fprintf(stderr, "Can't open database: %s\n", sqlite3_errmsg(db));
        return EXIT_FAILURE;
    } else {
        printf("Opened database successfully\n");
    }

    // Create a table
    create_table(db);

    // Insert some students
    insert_student(db, "Alice", 20, "Computer Science");
    insert_student(db, "Bob", 22, "Mathematics");
    insert_student(db, "Charlie", 21, "Physics");
    insert_student(db, "Daisy", 23, "Chemistry");

    // Query and display all students
    query_students(db);

    // Close the database connection
    sqlite3_close(db);
    return EXIT_SUCCESS;
}