//Gemma-7B DATASET v1.0 Category: CPU Scheduling Algorithms ; Style: Cyberpunk
#include <stdlib.h>
#include <stdio.h>

#define MAX_PROCESSES 5

struct process {
    int id;
    int arrivalTime;
    int burstTime;
    int completionTime;
    int waitingTime;
    int turnAroundTime;
};

void calculateProcessCompletionTime(struct process *processes) {
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].completionTime = processes[i].arrivalTime + processes[i].burstTime;
    }
}

void calculateWaitingTime(struct process *processes) {
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].waitingTime = processes[i].arrivalTime - processes[i].completionTime;
    }
}

void calculateTurnAroundTime(struct process *processes) {
    int i;
    for (i = 0; i < MAX_PROCESSES; i++) {
        processes[i].turnAroundTime = processes[i].waitingTime + processes[i].burstTime;
    }
}

int main() {
    struct process processes[MAX_PROCESSES];

    // Create processes
    processes[0].id = 0;
    processes[0].arrivalTime = 0;
    processes[0].burstTime = 5;

    processes[1].id = 1;
    processes[1].arrivalTime = 2;
    processes[1].burstTime = 4;

    processes[2].id = 2;
    processes[2].arrivalTime = 3;
    processes[2].burstTime = 3;

    processes[3].id = 3;
    processes[3].arrivalTime = 4;
    processes[3].burstTime = 2;

    processes[4].id = 4;
    processes[4].arrivalTime = 5;
    processes[4].burstTime = 1;

    // Calculate process completion time
    calculateProcessCompletionTime(processes);

    // Calculate waiting time
    calculateWaitingTime(processes);

    // Calculate turn around time
    calculateTurnAroundTime(processes);

    // Print results
    for (int i = 0; i < MAX_PROCESSES; i++) {
        printf("Process ID: %d\n", processes[i].id);
        printf("Arrival Time: %d\n", processes[i].arrivalTime);
        printf("Burst Time: %d\n", processes[i].burstTime);
        printf("Completion Time: %d\n", processes[i].completionTime);
        printf("Waiting Time: %d\n", processes[i].waitingTime);
        printf("Turn Around Time: %d\n", processes[i].turnAroundTime);
        printf("\n");
    }

    return 0;
}