//GEMINI-pro DATASET v1.0 Category: Threading Library Implementation ; Style: relaxed
#include <stdlib.h>
#include <pthread.h>
#include <stdio.h>

typedef struct thread_data {
    int id;
    int *array;
    int size;
} thread_data;

void *thread_routine(void *arg) {
    thread_data *data = (thread_data *)arg;

    for (int i = 0; i < data->size; i++) {
        data->array[i] *= data->id;
    }

    return NULL;
}

int main() {
    int num_threads = 4;
    int size = 100;
    int array[size];

    for (int i = 0; i < size; i++) {
        array[i] = i;
    }

    pthread_t threads[num_threads];
    thread_data data[num_threads];

    for (int i = 0; i < num_threads; i++) {
        data[i].id = i + 1;
        data[i].array = array;
        data[i].size = size;

        if (pthread_create(&threads[i], NULL, thread_routine, &data[i]) != 0) {
            perror("pthread_create");
            exit(EXIT_FAILURE);
        }
    }

    for (int i = 0; i < num_threads; i++) {
        if (pthread_join(threads[i], NULL) != 0) {
            perror("pthread_join");
            exit(EXIT_FAILURE);
        }
    }

    for (int i = 0; i < size; i++) {
        printf("%d ", array[i]);
    }

    printf("\n");

    return 0;
}