//GEMINI-pro DATASET v1.0 Category: Game ; Style: shape shifting
#include <stdio.h>
#include <stdlib.h>

enum Shapes { CIRCLE, TRIANGLE, SQUARE, HEXAGON, OCTAGON, STAR };

struct Shape {
    int type;
    double width;
    double height;
};

struct Circle {
    int type;
    double radius;
};

struct Triangle {
    int type;
    double base;
    double height;
};

struct Square {
    int type;
    double side;
};

struct Hexagon {
    int type;
    double side;
};

struct Octagon {
    int type;
    double side;
};

struct Star {
    int type;
    double num_points;
    double radius;
};

void printShape(struct Shape *shape) {
    switch (shape->type) {
        case CIRCLE:
            printf("Circle: radius = %f\n", ((struct Circle *)shape)->radius);
            break;
        case TRIANGLE:
            printf("Triangle: base = %f, height = %f\n", ((struct Triangle *)shape)->base, ((struct Triangle *)shape)->height);
            break;
        case SQUARE:
            printf("Square: side = %f\n", ((struct Square *)shape)->side);
            break;
        case HEXAGON:
            printf("Hexagon: side = %f\n", ((struct Hexagon *)shape)->side);
            break;
        case OCTAGON:
            printf("Octagon: side = %f\n", ((struct Octagon *)shape)->side);
            break;
        case STAR:
            printf("Star: num_points = %f, radius = %f\n", ((struct Star *)shape)->num_points, ((struct Star *)shape)->radius);
            break;
    }
}

int main() {
    // Create a circle
    struct Circle circle = { .type = CIRCLE, .radius = 5.0 };

    // Create a triangle
    struct Triangle triangle = { .type = TRIANGLE, .base = 10.0, .height = 8.0 };

    // Create a square
    struct Square square = { .type = SQUARE, .side = 6.0 };

    // Create a hexagon
    struct Hexagon hexagon = { .type = HEXAGON, .side = 4.0 };

    // Create an octagon
    struct Octagon octagon = { .type = OCTAGON, .side = 3.0 };

    // Create a star
    struct Star star = { .type = STAR, .num_points = 5, .radius = 2.0 };

    // Print the shapes
    printShape((struct Shape *)&circle);
    printShape((struct Shape *)&triangle);
    printShape((struct Shape *)&square);
    printShape((struct Shape *)&hexagon);
    printShape((struct Shape *)&octagon);
    printShape((struct Shape *)&star);

    return 0;
}