//LLAMA2-13B DATASET v1.0 Category: Hotel Management System ; Style: irregular
// This is a C Hotel Management System, and it's going to be a wild ride!

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

// Declare global variables
int num_rooms = 0;
int num_guests = 0;
int max_guests = 0;
char hotel_name[50];

// Function to check if a room is available
int check_availability(int room_number) {
  if (room_number > num_rooms) {
    printf("Room %d does not exist!\n", room_number);
    return 0;
  }

  if (num_guests >= max_guests) {
    printf("Sorry, the hotel is fully booked!\n");
    return 0;
  }

  return 1;
}

// Function to book a room
void book_room(int room_number) {
  if (!check_availability(room_number)) {
    return;
  }

  num_guests++;
  printf("You have booked room %d!\n", room_number);
}

// Function to check if a guest has checked out
int check_checkout(int room_number) {
  if (room_number > num_rooms) {
    printf("Room %d does not exist!\n", room_number);
    return 0;
  }

  if (num_guests <= 0) {
    printf("There are no guests to check out!\n");
    return 0;
  }

  if (room_number == num_rooms) {
    num_guests--;
    printf("You have checked out of room %d!\n", room_number);
    return 1;
  }

  return 0;
}

// Function to check if a guest has checked in
int check_checkin(int room_number) {
  if (room_number > num_rooms) {
    printf("Room %d does not exist!\n", room_number);
    return 0;
  }

  if (num_guests >= max_guests) {
    printf("Sorry, the hotel is fully booked!\n");
    return 0;
  }

  num_guests++;
  printf("You have checked into room %d!\n", room_number);
  return 1;
}

// Function to print the current state of the hotel
void print_state() {
  printf("Hotel State:\n");
  printf("  Num rooms: %d\n", num_rooms);
  printf("  Num guests: %d\n", num_guests);
  printf("  Max guests: %d\n", max_guests);
  printf("  Hotel name: %s\n", hotel_name);
}

int main() {
  // Ask the user for the hotel name
  printf("Enter the name of the hotel: ");
  scanf("%49s", hotel_name);

  // Set the maximum number of guests
  max_guests = 100;

  // Create rooms
  for (int i = 1; i <= 10; i++) {
    book_room(i);
  }

  // Check if a guest has checked in
  if (check_checkin(1)) {
    printf("You have checked into room 1!\n");
  } else {
    printf("Sorry, room 1 is not available!\n");
  }

  // Check if a guest has checked out
  if (check_checkout(1)) {
    printf("You have checked out of room 1!\n");
  } else {
    printf("Sorry, room 1 does not exist!\n");
  }

  // Print the current state of the hotel
  print_state();

  return 0;
}