//GEMINI-pro DATASET v1.0 Category: Robot movement control ; Style: Cyberpunk
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_COMMANDS 100

typedef struct {
    char *command;
    int (*function)(char **args);
} command_t;

int move_forward(char **args);
int move_backward(char **args);
int turn_left(char **args);
int turn_right(char **args);
int fire_weapon(char **args);

command_t commands[] = {
    {"move_forward", move_forward},
    {"move_backward", move_backward},
    {"turn_left", turn_left},
    {"turn_right", turn_right},
    {"fire_weapon", fire_weapon},
    {NULL, NULL}
};

int main() {
    char *input = NULL;
    size_t input_size = 0;
    ssize_t input_length = getline(&input, &input_size, stdin);
    if (input_length == -1) {
        perror("getline");
        exit(EXIT_FAILURE);
    }

    char *command = strtok(input, " ");
    while (command != NULL) {
        int i;
        for (i = 0; commands[i].command != NULL; i++) {
            if (strcmp(command, commands[i].command) == 0) {
                char **args = strtok(NULL, " ");
                commands[i].function(args);
                break;
            }
        }

        if (commands[i].command == NULL) {
            printf("Unknown command: %s\n", command);
        }

        command = strtok(NULL, " ");
    }

    free(input);

    return EXIT_SUCCESS;
}

int move_forward(char **args) {
    printf("Moving forward\n");
    return 0;
}

int move_backward(char **args) {
    printf("Moving backward\n");
    return 0;
}

int turn_left(char **args) {
    printf("Turning left\n");
    return 0;
}

int turn_right(char **args) {
    printf("Turning right\n");
    return 0;
}

int fire_weapon(char **args) {
    printf("Firing weapon\n");
    return 0;
}