//Falcon-180B DATASET v1.0 Category: System administration ; Style: detailed
// This is a program that simulates a simple file system
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_FILES 10
#define MAX_FILE_NAME_SIZE 20
#define MAX_FILE_SIZE 1000

typedef struct {
    char name[MAX_FILE_NAME_SIZE];
    int size;
    char contents[MAX_FILE_SIZE];
} File;

File files[MAX_FILES];
int num_files = 0;

void create_file(char* name, int size) {
    if (num_files >= MAX_FILES) {
        printf("Error: File system is full.\n");
        return;
    }

    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(name, files[i].name) == 0) {
            printf("Error: File already exists.\n");
            return;
        }
    }

    strcpy(files[num_files].name, name);
    files[num_files].size = size;
    files[num_files].contents[0] = '\0';
    num_files++;

    printf("File created successfully.\n");
}

void delete_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(name, files[i].name) == 0) {
            memset(files[i].contents, 0, MAX_FILE_SIZE);
            num_files--;
            printf("File deleted successfully.\n");
            return;
        }
    }

    printf("Error: File not found.\n");
}

void write_to_file(char* name, char* contents) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(name, files[i].name) == 0) {
            strcpy(files[i].contents, contents);
            printf("File written successfully.\n");
            return;
        }
    }

    printf("Error: File not found.\n");
}

void read_from_file(char* name) {
    int i;
    for (i = 0; i < num_files; i++) {
        if (strcmp(name, files[i].name) == 0) {
            printf("File contents: %s\n", files[i].contents);
            return;
        }
    }

    printf("Error: File not found.\n");
}

int main() {
    create_file("test.txt", 10);
    write_to_file("test.txt", "Hello, world!");
    read_from_file("test.txt");
    delete_file("test.txt");

    return 0;
}