//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: standalone
#include <stdio.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <stdlib.h>
#include <unistd.h>
#include <errno.h>

int main()
{
    // Create a TCP socket
    int sock = socket(AF_INET, SOCK_STREAM, 0);
    if (sock < 0)
    {
        perror("socket");
        exit(EXIT_FAILURE);
    }

    // Set the socket options
    int optval = 1;
    if (setsockopt(sock, SOL_SOCKET, SO_REUSEADDR, &optval, sizeof(int)) < 0)
    {
        perror("setsockopt");
        exit(EXIT_FAILURE);
    }

    // Bind the socket to an IP address and port
    struct sockaddr_in server_addr;
    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = INADDR_ANY;
    server_addr.sin_port = htons(8080);
    if (bind(sock, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("bind");
        exit(EXIT_FAILURE);
    }

    // Listen for incoming connections
    if (listen(sock, 5) < 0)
    {
        perror("listen");
        exit(EXIT_FAILURE);
    }

    // Accept an incoming connection
    struct sockaddr_in client_addr;
    socklen_t client_addr_len = sizeof(client_addr);
    int client_sock = accept(sock, (struct sockaddr *)&client_addr, &client_addr_len);
    if (client_sock < 0)
    {
        perror("accept");
        exit(EXIT_FAILURE);
    }

    // Send a message to the client
    const char *message = "Hello, world!\n";
    if (send(client_sock, message, strlen(message), 0) < 0)
    {
        perror("send");
        exit(EXIT_FAILURE);
    }

    // Receive a message from the client
    char buffer[256];
    if (recv(client_sock, buffer, sizeof(buffer), 0) < 0)
    {
        perror("recv");
        exit(EXIT_FAILURE);
    }

    // Print the message from the client
    printf("Received: %s", buffer);

    // Close the client socket
    if (close(client_sock) < 0)
    {
        perror("close");
        exit(EXIT_FAILURE);
    }

    // Close the server socket
    if (close(sock) < 0)
    {
        perror("close");
        exit(EXIT_FAILURE);
    }

    return EXIT_SUCCESS;
}