//GPT-4o-mini DATASET v1.0 Category: Packet Capturer with pcap library ; Style: mathematical
#include <stdio.h>
#include <stdlib.h>
#include <pcap.h>
#include <arpa/inet.h>
#include <netinet/ip.h>
#include <netinet/tcp.h>
#include <netinet/udp.h>

// Define a function to compute packet statistics
void compute_packet_stats(const struct pcap_pkthdr *header, const u_char *packet) {
    static unsigned long total_packets = 0;
    static unsigned long total_bytes = 0;

    total_packets++;
    total_bytes += header->len;

    printf("Total Packets: %lu\n", total_packets);
    printf("Total Bytes: %lu\n\n", total_bytes);
}

// Define a function to print IP packet information in a mathematical style
void print_ip_info(const struct ip *ip_header) {
    struct in_addr src, dst;
    src.s_addr = ip_header->ip_src.s_addr;
    dst.s_addr = ip_header->ip_dst.s_addr;
    printf("Packet Info:\n");
    printf("Source IP: %s\n", inet_ntoa(src));
    printf("Destination IP: %s\n", inet_ntoa(dst));
    printf("Protocol: %d\n", ip_header->ip_p);
}

// Function to analyze and classify TCP packets
void analyze_tcp(const u_char *packet) {
    struct ip *ip_header = (struct ip *)(packet + 14); // Assuming Ethernet header
    struct tcphdr *tcp_header = (struct tcphdr *)(packet + 14 + (ip_header->ip_hl * 4));

    print_ip_info(ip_header);
    printf("TCP Source Port: %u\n", ntohs(tcp_header->th_sport));
    printf("TCP Dest Port: %u\n", ntohs(tcp_header->th_dport));
    printf("Sequence Number: %u\n", ntohl(tcp_header->th_seq));
    printf("Acknowledgment Number: %u\n\n", ntohl(tcp_header->th_ack));
}

// Function to analyze and classify UDP packets
void analyze_udp(const u_char *packet) {
    struct ip *ip_header = (struct ip *)(packet + 14); // Assuming Ethernet header
    struct udphdr *udp_header = (struct udphdr *)(packet + 14 + (ip_header->ip_hl * 4));

    print_ip_info(ip_header);
    printf("UDP Source Port: %u\n", ntohs(udp_header->uh_sport));
    printf("UDP Dest Port: %u\n", ntohs(udp_header->uh_dport));
    printf("Length: %u\n\n", ntohs(udp_header->uh_ulen));
}

// The packet processing function
void packet_handler(u_char *args, const struct pcap_pkthdr *header, const u_char *packet) {
    compute_packet_stats(header, packet);
    
    struct ip *ip_header = (struct ip *)(packet + 14); // Assuming Ethernet header
    switch (ip_header->ip_p) {
        case IPPROTO_TCP:
            analyze_tcp(packet);
            break;
        case IPPROTO_UDP:
            analyze_udp(packet);
            break;
        default:
            printf("Other Protocol: %d\n", ip_header->ip_p);
            break;
    }
}

// The main function to initiate the capture
int main(int argc, char *argv[]) {
    char *dev, errbuf[PCAP_ERRBUF_SIZE];
    pcap_t *handle;

    if(argc != 2) {
        fprintf(stderr, "Usage: %s <interface>\n", argv[0]);
        return 1;
    }

    dev = argv[1];
    handle = pcap_open_live(dev, BUFSIZ, 1, 1000, errbuf);
    if (handle == NULL) {
        fprintf(stderr, "Could not open device %s: %s\n", dev, errbuf);
        return 2;
    }

    pcap_loop(handle, 10, packet_handler, NULL);

    pcap_close(handle);
    return 0;
}