//GPT-4o-mini DATASET v1.0 Category: Pathfinding algorithms ; Style: Ada Lovelace
#include <stdio.h>
#include <stdlib.h>
#include <stdbool.h>
#include <limits.h>

#define ROW 9
#define COL 10

struct Point {
    int x;
    int y;
};

// A utility function to check whether a given cell (row, col)
// can be included in the path
bool isSafe(int maze[ROW][COL], int row, int col) {
    return (row >= 0 && row < ROW && col >= 0 && col < COL && maze[row][col] == 1);
}

// A utility function to print the solution matrix
void printSolution(int path[ROW][COL]) {
    for (int i = 0; i < ROW; i++) {
        for (int j = 0; j < COL; j++) {
            printf(" %d ", path[i][j]);
        }
        printf("\n");
    }
}

// A recursive utility function to solve the maze problem
bool solveMazeUtil(int maze[ROW][COL], int x, int y, int path[ROW][COL]) {
    // If (x,y) is the bottom-right corner, we have reached the destination
    if (x == ROW - 1 && y == COL - 1) {
        path[x][y] = 1;
        return true;
    }

    // Check if maze[x][y] is valid
    if (isSafe(maze, x, y)) {
        // Mark x,y as part of solution path
        path[x][y] = 1;

        // Move forward in x direction
        if (solveMazeUtil(maze, x + 1, y, path))
            return true;

        // If moving in x direction doesn't give a solution
        // then move down in y direction
        if (solveMazeUtil(maze, x, y + 1, path))
            return true;

        // If none of the above movements work then
        // BACKTRACK: unmark x,y as part of solution path
        path[x][y] = 0;
        return false;
    }
    return false;
}

// This function solves the Maze problem using the backtracking
bool solveMaze(int maze[ROW][COL]) {
    int path[ROW][COL] = { { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 } };

    if (solveMazeUtil(maze, 0, 0, path) == false) {
        printf("Solution doesn't exist");
        return false;
    }

    printSolution(path);
    return true;
}

// Driver code
int main() {
    // Maze representation: 1 = path, 0 = wall
    int maze[ROW][COL] = { { 1, 0, 0, 0, 0, 0, 0, 0, 0, 0 },
                           { 1, 1, 0, 1, 1, 1, 0, 0, 0, 0 },
                           { 0, 1, 0, 0, 0, 1, 0, 1, 1, 0 },
                           { 0, 1, 0, 1, 0, 0, 0, 1, 0, 0 },
                           { 0, 0, 0, 0, 1, 0, 1, 1, 1, 0 },
                           { 0, 1, 1, 0, 0, 0, 0, 0, 0, 1 },
                           { 0, 0, 0, 0, 1, 1, 0, 1, 0, 0 },
                           { 0, 1, 0, 0, 0, 0, 0, 1, 0, 0 },
                           { 0, 0, 0, 1, 1, 1, 1, 0, 0, 1 } };

    solveMaze(maze);
    return 0;
}