//GPT-4o-mini DATASET v1.0 Category: Periodic Table Quiz ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define ELEMENT_COUNT 10

typedef struct {
    char name[20];
    char symbol[3];
    int atomic_number;
} Element;

void shuffle(int *array, size_t n) {
    if (n > 1) {
        for (size_t i = 0; i < n - 1; i++) {
            size_t j = i + rand() / (RAND_MAX / (n - i) + 1);
            int temp = array[j];
            array[j] = array[i];
            array[i] = temp;
        }
    }
}

void printInstructions() {
    printf("Welcome to the Periodic Table Quiz!\n");
    printf("You will be asked to provide the symbol or name of an element based on its atomic number.\n");
    printf("Answer correctly to score points!\n");
    printf("Good luck! Let's see how much you know about the elements!\n\n");
}

void quiz(Element elements[], int *score) {
    int indices[ELEMENT_COUNT];
    for (int i = 0; i < ELEMENT_COUNT; i++) {
        indices[i] = i;
    }
    
    shuffle(indices, ELEMENT_COUNT);

    for (int i = 0; i < ELEMENT_COUNT; i++) {
        int index = indices[i];
        printf("Question %d:\n", i + 1);
        printf("What is the symbol for the element with atomic number %d? ", elements[index].atomic_number);
        
        char answer[3];
        scanf("%2s", answer);
        
        if (strcasecmp(answer, elements[index].symbol) == 0) {
            printf("Correct! %s\n\n", elements[index].name);
            (*score)++;
        } else {
            printf("Incorrect! The correct symbol is %s.\n\n", elements[index].symbol);
        }
    }
}

int main() {
    srand(time(NULL));
    Element elements[ELEMENT_COUNT] = {
        {"Hydrogen", "H", 1},
        {"Helium", "He", 2},
        {"Lithium", "Li", 3},
        {"Beryllium", "Be", 4},
        {"Boron", "B", 5},
        {"Carbon", "C", 6},
        {"Nitrogen", "N", 7},
        {"Oxygen", "O", 8},
        {"Fluorine", "F", 9},
        {"Neon", "Ne", 10}
    };

    int score = 0;
    
    printInstructions();
    quiz(elements, &score);
    
    printf("You have completed the quiz! Your score is: %d out of %d\n", score, ELEMENT_COUNT);
    
    return 0;
}