//Gemma-7B DATASET v1.0 Category: Tic Tac Toe AI ; Style: Romeo and Juliet
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define BOARD_SIZE 3

typedef enum CellState { EMPTY, PLAYER1, PLAYER2 } CellState;

CellState board[BOARD_SIZE][BOARD_SIZE] = {{EMPTY, EMPTY, EMPTY},
    {EMPTY, EMPTY, EMPTY},
    {EMPTY, EMPTY, EMPTY}
};

int get_available_cell(void) {
    for (int r = 0; r < BOARD_SIZE; r++) {
        for (int c = 0; c < BOARD_SIZE; c++) {
            if (board[r][c] == EMPTY) {
                return r * BOARD_SIZE + c;
            }
        }
    }

    return -1;
}

void place_mark(int cell_index, CellState state) {
    board[cell_index / BOARD_SIZE][cell_index % BOARD_SIZE] = state;
}

int check_win(CellState state) {
    // Check rows
    for (int r = 0; r < BOARD_SIZE; r++) {
        if (board[r][0] == state && board[r][1] == state && board[r][2] == state) {
            return 1;
        }
    }

    // Check columns
    for (int c = 0; c < BOARD_SIZE; c++) {
        if (board[0][c] == state && board[1][c] == state && board[2][c] == state) {
            return 1;
        }
    }

    // Check diagonals
    if (board[0][0] == state && board[1][1] == state && board[2][2] == state) {
        return 1;
    }

    // If all cells are occupied and there is no winner, it's a draw
    return 0;
}

int main() {
    // Seed the random number generator
    srand(time(NULL));

    // Initialize the board
    for (int r = 0; r < BOARD_SIZE; r++) {
        for (int c = 0; c < BOARD_SIZE; c++) {
            board[r][c] = EMPTY;
        }
    }

    // Game loop
    int game_state = 0;
    while (!game_state) {
        // Get the player's move
        int move = get_available_cell();

        // Place the mark
        place_mark(move, PLAYER1);

        // Check if the player has won or there is a draw
        game_state = check_win(PLAYER1);

        // If the player has won, they are the winner
        if (game_state) {
            printf("Player 1 has won!");
        }

        // If there is a draw, it's a draw
        else if (move == -1) {
            printf("It's a draw!");
        }
    }

    return 0;
}