//Falcon-180B DATASET v1.0 Category: Cryptographic hash function ; Style: distributed
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>
#include <pthread.h>

#define NUM_THREADS 4

// function prototypes
void *hash_thread(void *data);
unsigned int hash(char *input);

int main() {
    pthread_t threads[NUM_THREADS];
    char *input = "Hello World!";
    int i;

    // create threads
    for (i = 0; i < NUM_THREADS; i++) {
        pthread_create(&threads[i], NULL, hash_thread, input);
    }

    // join threads
    for (i = 0; i < NUM_THREADS; i++) {
        pthread_join(threads[i], NULL);
    }

    printf("Hash: %u\n", hash(input));

    return 0;
}

// hash function
unsigned int hash(char *input) {
    unsigned int hash_value = 0;
    int i;

    for (i = 0; i < strlen(input); i++) {
        hash_value += input[i];
    }

    return hash_value;
}

// thread function
void *hash_thread(void *data) {
    char *input = (char *) data;
    unsigned int hash_value = hash(input);

    printf("Thread %d: Hash: %u\n", (int) pthread_self(), hash_value);

    return NULL;
}