//Falcon2-11B DATASET v1.0 Category: Building a XML Parser ; Style: random
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_XML_LEN 1024

typedef struct {
    char* name;
    char* value;
} XmlElement;

void xml_init(XmlElement* elem) {
    elem->name = NULL;
    elem->value = NULL;
}

void xml_add_name(XmlElement* elem, char* name) {
    if (elem->name!= NULL) {
        free(elem->name);
    }
    elem->name = strdup(name);
}

void xml_add_value(XmlElement* elem, char* value) {
    if (elem->value!= NULL) {
        free(elem->value);
    }
    elem->value = strdup(value);
}

void xml_free(XmlElement* elem) {
    if (elem->name!= NULL) {
        free(elem->name);
    }
    if (elem->value!= NULL) {
        free(elem->value);
    }
}

int main() {
    XmlElement xml;
    xml_init(&xml);

    xml_add_name(&xml, "name");
    xml_add_value(&xml, "John");

    xml_add_name(&xml, "age");
    xml_add_value(&xml, "25");

    printf("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
    printf("<root>\n");
    printf("  <name>%s</name>\n", xml.name);
    printf("  <age>%s</age>\n", xml.value);
    printf("</root>\n");

    xml_free(&xml);

    return 0;
}