//Falcon-180B DATASET v1.0 Category: Smart home light control ; Style: future-proof
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <stdbool.h>

#define MAX_LIGHTS 10

typedef struct {
    char name[50];
    bool is_on;
    int brightness;
} light_t;

light_t lights[MAX_LIGHTS];

void init_lights() {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        lights[i].is_on = false;
        lights[i].brightness = 0;
    }
}

void add_light(char* name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].is_on == false) {
            strcpy(lights[i].name, name);
            lights[i].is_on = true;
            break;
        }
    }
}

void remove_light(char* name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].is_on = false;
            strcpy(lights[i].name, "");
            break;
        }
    }
}

void toggle_light(char* name) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].is_on =!lights[i].is_on;
            break;
        }
    }
}

void set_brightness(char* name, int brightness) {
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (strcmp(lights[i].name, name) == 0) {
            lights[i].brightness = brightness;
            break;
        }
    }
}

void print_lights() {
    printf("Lights:\n");
    for (int i = 0; i < MAX_LIGHTS; i++) {
        if (lights[i].is_on) {
            printf("- %s (brightness: %d)\n", lights[i].name, lights[i].brightness);
        }
    }
}

int main() {
    init_lights();
    add_light("Living Room");
    add_light("Bedroom");
    print_lights();
    toggle_light("Living Room");
    set_brightness("Bedroom", 50);
    print_lights();
    remove_light("Living Room");
    print_lights();
    return 0;
}