//GEMINI-pro DATASET v1.0 Category: Percolation Simulator ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define SIZE 10

int grid[SIZE][SIZE];

void printGrid() {
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            printf("%d ", grid[i][j]);
        }
        printf("\n");
    }
}

int main() {
    srand(time(NULL));

    // Initialize the grid
    for (int i = 0; i < SIZE; i++) {
        for (int j = 0; j < SIZE; j++) {
            grid[i][j] = 0;
        }
    }

    // Open some random cells
    for (int i = 0; i < SIZE * SIZE / 2; i++) {
        int x = rand() % SIZE;
        int y = rand() % SIZE;
        grid[x][y] = 1;
    }

    // Check if the grid percolates
    int percolates = 0;
    for (int i = 0; i < SIZE; i++) {
        if (grid[i][0] == 1) {
            for (int j = 0; j < SIZE; j++) {
                if (grid[i][j] == 1) {
                    percolates = 1;
                    break;
                }
            }
            if (percolates) {
                break;
            }
        }
    }

    // Print the grid
    printGrid();

    // Print whether the grid percolates
    if (percolates) {
        printf("The grid percolates.\n");
    } else {
        printf("The grid does not percolate.\n");
    }

    return 0;
}