//Falcon-180B DATASET v1.0 Category: Text to ASCII art generator ; Style: complete
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_WIDTH 80
#define MAX_HEIGHT 25
#define MAX_CHARS (MAX_WIDTH * MAX_HEIGHT)

typedef struct {
    char *text;
    int foreground;
    int background;
} TextStyle;

typedef struct {
    char *text;
    int width;
    int height;
    TextStyle style;
} TextBox;

void set_text_style(TextStyle *style, int foreground, int background) {
    style->foreground = foreground;
    style->background = background;
}

void set_text_box_style(TextBox *box, int foreground, int background) {
    set_text_style(&box->style, foreground, background);
}

void set_text_box_text(TextBox *box, char *text) {
    box->text = text;
    box->width = strlen(text);
    if (box->width > MAX_WIDTH) {
        box->width = MAX_WIDTH;
    }
    box->height = (box->width + MAX_WIDTH - 1) / MAX_WIDTH;
}

void print_text_box(TextBox *box) {
    int i, j;
    for (i = 0; i < box->height; i++) {
        for (j = 0; j < box->width; j++) {
            if (j * MAX_WIDTH + i * MAX_WIDTH < box->width) {
                printf("%c", box->text[j * MAX_WIDTH + i * MAX_WIDTH]);
            } else {
                printf(" ");
            }
        }
        printf("\n");
    }
}

int main() {
    TextBox box;
    set_text_box_style(&box, 7, 0);
    set_text_box_text(&box, "Hello, world!");
    print_text_box(&box);

    return 0;
}