//MISTRAL-7B DATASET v1.0 Category: Sentiment analysis tool ; Style: minimalist
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <stdbool.h>

#define MAX_TOKEN_LENGTH 50
#define NUM_RULES 10

typedef struct {
    char word[MAX_TOKEN_LENGTH];
    int sentiment;
} Rule;

Rule rules[NUM_RULES] = {
    {"good", 1},
    {"great", 1},
    {"happy", 1},
    {"love", 1},
    {"excited", 1},
    {"bad", -1},
    {"terrible", -1},
    {"sad", -1},
    {"hate", -1},
    {"angry", -1}
};

bool is_delimiter(char c) {
    return (c == ' ' || c == '\t' || c == '\n');
}

int analyze_sentiment(char *input) {
    char tokens[10][MAX_TOKEN_LENGTH];
    int num_tokens = 0, total_sentiment = 0;
    char *token = strtok(input, " \t\n");

    while (token != NULL) {
        strcpy(tokens[num_tokens++], token);
        token = strtok(NULL, " \t\n");
    }

    for (int i = 0; i < num_tokens; ++i) {
        for (int j = 0; j < NUM_RULES; ++j) {
            if (strcasecmp(tokens[i], rules[j].word) == 0) {
                total_sentiment += rules[j].sentiment;
                break;
            }
        }
    }

    return total_sentiment;
}

int main() {
    char input[100];
    int sentiment;

    printf("Enter your text: ");
    fgets(input, sizeof(input), stdin);
    input[strcspn(input, "\n")] = '\0';

    sentiment = analyze_sentiment(input);

    if (sentiment > 0) {
        printf("Sentiment: Positive\n");
    } else if (sentiment < 0) {
        printf("Sentiment: Negative\n");
    } else {
        printf("Sentiment: Neutral\n");
    }

    return 0;
}