//MISTRAL-7B DATASET v1.0 Category: Compression algorithms ; Style: single-threaded
#include <stdio.h>
#include <stdlib.h>

#define MAX_INPUT_SIZE 1024
#define MIN_FREQUENCY 3

typedef struct {
    unsigned char data;
    unsigned int count;
} RLE_ENTRY;

void compress_rle(unsigned char *input, unsigned int input_size, unsigned char *output) {
    RLE_ENTRY *entry = malloc(input_size * sizeof(RLE_ENTRY));
    unsigned int index = 0, output_index = 0;

    if (!entry) {
        printf("Memory allocation failed.\n");
        return;
    }

    while (index < input_size) {
        if (index + 1 < input_size && input[index] == input[index + 1]) {
            entry[output_index].data = input[index];
            entry[output_index].count++;
            index++;
        } else {
            output[output_index++] = entry[output_index - 1].data;
            output[output_index++] = (unsigned char)(entry[output_index - 1].count >> 1);
            entry[output_index].data = input[index];
            entry[output_index].count = 1;
            index++;
        }
    }

    output[output_index++] = '\0';

    free(entry);

    for (unsigned int i = 0; i < output_index - 1; i++) {
        output[i] = output[i] + (output[i + 1] << 1);
    }

    printf("Compressed size: %d\n", output_index);
}

int main() {
    unsigned char input[MAX_INPUT_SIZE] = { 0 };
    unsigned char *output;
    unsigned int input_size = 0;

    printf("Enter input data (press Ctrl+D to end): ");

    while ((input[input_size++] = getchar()) != EOF);

    rewind(stdin);

    output = malloc(input_size * sizeof(unsigned char) + sizeof(unsigned char));

    if (!output) {
        printf("Memory allocation failed.\n");
        return 1;
    }

    compress_rle(input, input_size, output);

    FILE *fp = fopen("output.bin", "wb");

    if (!fp) {
        printf("Failed to open output file.\n");
        free(output);
        return 1;
    }

    fwrite(output, input_size + sizeof(unsigned char), 1, fp);
    fclose(fp);

    printf("Compression completed. Output file: output.bin\n");

    free(output);

    return 0;
}