//Falcon-180B DATASET v1.0 Category: Text Summarizer ; Style: optimized
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>

#define MAX_SENTENCE_LENGTH 100
#define MAX_SENTENCES 1000
#define MIN_SENTENCE_LENGTH 5

typedef struct {
    char text[MAX_SENTENCE_LENGTH];
    int length;
} Sentence;

Sentence sentences[MAX_SENTENCES];
int numSentences;

void addSentence(char* sentence) {
    if (numSentences >= MAX_SENTENCES) {
        printf("Error: Too many sentences.\n");
        return;
    }

    int length = strlen(sentence);
    if (length < MIN_SENTENCE_LENGTH) {
        printf("Error: Sentence is too short.\n");
        return;
    }

    strcpy(sentences[numSentences].text, sentence);
    sentences[numSentences].length = length;

    numSentences++;
}

void summarize() {
    if (numSentences == 0) {
        printf("No sentences to summarize.\n");
        return;
    }

    int totalLength = 0;
    for (int i = 0; i < numSentences; i++) {
        totalLength += sentences[i].length;
    }

    int maxLength = totalLength / numSentences;
    int currentLength = 0;

    printf("Summary:\n");
    for (int i = 0; i < numSentences; i++) {
        if (sentences[i].length <= maxLength) {
            printf("%s\n", sentences[i].text);
            currentLength += sentences[i].length;
        } else {
            int j;
            for (j = 0; j < maxLength - 3; j++) {
                if (isspace(sentences[i].text[j])) {
                    break;
                }
            }
            sentences[i].text[j] = '\0';
            printf("%s...\n", sentences[i].text);
            currentLength += j;
        }

        if (currentLength >= maxLength * (i + 1)) {
            break;
        }
    }
}

int main() {
    addSentence("The quick brown fox jumps over the lazy dog.");
    addSentence("Sphinx of black quartz, judge my vow.");
    addSentence("Pack my box with five dozen liquor jugs.");
    summarize();

    return 0;
}