//GEMINI-pro DATASET v1.0 Category: Percolation Simulator ; Style: peaceful
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#define GRID_SIZE 10
#define P 0.5

// Define the grid
int grid[GRID_SIZE][GRID_SIZE];

// Function to initialize the grid
void initialize_grid() {
  for (int i = 0; i < GRID_SIZE; i++) {
    for (int j = 0; j < GRID_SIZE; j++) {
      grid[i][j] = 0;
    }
  }
}

// Function to open a site
void open_site(int i, int j) {
  grid[i][j] = 1;
}

// Function to check if a site is open
int is_open(int i, int j) {
  return grid[i][j] == 1;
}

// Function to check if a site is connected to the top
int is_connected_to_top(int i, int j) {
  if (i == 0) {
    return 1;
  } else {
    return is_open(i - 1, j);
  }
}

// Function to check if a site is connected to the bottom
int is_connected_to_bottom(int i, int j) {
  if (i == GRID_SIZE - 1) {
    return 1;
  } else {
    return is_open(i + 1, j);
  }
}

// Function to check if a site is connected to the left
int is_connected_to_left(int i, int j) {
  if (j == 0) {
    return 1;
  } else {
    return is_open(i, j - 1);
  }
}

// Function to check if a site is connected to the right
int is_connected_to_right(int i, int j) {
  if (j == GRID_SIZE - 1) {
    return 1;
  } else {
    return is_open(i, j + 1);
  }
}

// Function to check if a site is connected to any of its neighbors
int is_connected_to_any_neighbor(int i, int j) {
  return is_connected_to_top(i, j) || is_connected_to_bottom(i, j) ||
         is_connected_to_left(i, j) || is_connected_to_right(i, j);
}

// Function to check if the grid percolates
int does_grid_percolate() {
  for (int i = 0; i < GRID_SIZE; i++) {
    if (is_connected_to_top(i, 0) && is_connected_to_bottom(i, GRID_SIZE - 1)) {
      return 1;
    }
  }
  return 0;
}

// Function to print the grid
void print_grid() {
  for (int i = 0; i < GRID_SIZE; i++) {
    for (int j = 0; j < GRID_SIZE; j++) {
      printf("%d ", grid[i][j]);
    }
    printf("\n");
  }
}

int main() {
  // Initialize the random number generator
  srand(time(NULL));

  // Initialize the grid
  initialize_grid();

  // Open sites at random
  for (int i = 0; i < GRID_SIZE; i++) {
    for (int j = 0; j < GRID_SIZE; j++) {
      if (rand() < P * RAND_MAX) {
        open_site(i, j);
      }
    }
  }

  // Print the grid
  print_grid();

  // Check if the grid percolates
  if (does_grid_percolate()) {
    printf("The grid percolates.\n");
  } else {
    printf("The grid does not percolate.\n");
  }

  return 0;
}