//Falcon2-11B DATASET v1.0 Category: Fitness Tracker ; Style: high level of detail
#include <stdio.h>
#include <stdlib.h>

#define MAX_WORKOUTS 10

struct Workout {
    char name[20];
    int duration;
};

typedef struct Workout Workout;

int num_workouts = 0;
Workout workouts[MAX_WORKOUTS];

void add_workout(Workout workout) {
    if (num_workouts >= MAX_WORKOUTS) {
        printf("Too many workouts.\n");
        return;
    }

    num_workouts++;
    sprintf(workouts[num_workouts].name, "%s", workout.name);
    workouts[num_workouts].duration = workout.duration;
}

void display_workouts() {
    printf("Total number of workouts: %d\n", num_workouts);

    for (int i = 0; i < num_workouts; i++) {
        printf("Name: %s\n", workouts[i].name);
        printf("Duration: %d\n", workouts[i].duration);
    }
}

int total_workouts() {
    int total = 0;

    for (int i = 0; i < num_workouts; i++) {
        total += workouts[i].duration;
    }

    return total;
}

int main() {
    Workout workout;
    sprintf(workout.name, "Running");
    workout.duration = 30;

    add_workout(workout);

    sprintf(workout.name, "Cycling");
    workout.duration = 45;

    add_workout(workout);

    sprintf(workout.name, "Yoga");
    workout.duration = 60;

    add_workout(workout);

    display_workouts();
    printf("Total number of workouts: %d\n", total_workouts());

    return 0;
}