//Gemma-7B DATASET v1.0 Category: Network Quality of Service (QoS) monitor ; Style: accurate
#include <stdio.h>
#include <stdlib.h>
#include <netdb.h>
#include <sys/socket.h>
#include <unistd.h>

#define MAX_PACKET_SIZE 1024

int main()
{
    int sockfd, client_sockfd;
    struct sockaddr_in server_addr, client_addr;
    char buffer[MAX_PACKET_SIZE];

    // Create a socket
    sockfd = socket(AF_INET, SOCK_STREAM, htons(8080));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    // Bind the socket to a port
    server_addr.sin_port = htons(8080);
    if (bind(sockfd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    // Listen for clients
    client_sockfd = accept(sockfd, (struct sockaddr *)&client_addr, NULL);
    if (client_sockfd < 0)
    {
        perror("Error accepting client connection");
        exit(1);
    }

    // Receive a packet
    int bytes_received = recv(client_sockfd, buffer, MAX_PACKET_SIZE, 0);
    if (bytes_received < 0)
    {
        perror("Error receiving packet");
        exit(1);
    }

    // Print the packet contents
    printf("Received packet of %d bytes:\n", bytes_received);
    printf("Packet contents:\n");
    printf("%s\n", buffer);

    // Close the client socket
    close(client_sockfd);

    // Close the server socket
    close(sockfd);

    return 0;
}