//LLAMA2-13B DATASET v1.0 Category: Unit converter ; Style: surprised
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define UNIT_CONVERTER_MAX_UNITS 5
#define UNIT_CONVERTER_MAX_INPUT_LENGTH 20

// Structure to store unit information
typedef struct {
    char name[20];  // Unit name
    double conversion_factor;  // Conversion factor for this unit
} unit_t;

// Array to store all available units
unit_t units[UNIT_CONVERTER_MAX_UNITS] = {
    {"meter", 1.0},
    {"kilometer", 1000.0},
    {"inch", 0.0254},
    {"foot", 0.3048},
    {"yard", 0.9144}
};

// Function to convert a value from one unit to another
double convert_unit(double value, char from_unit[20], char to_unit[20]) {
    int i = 0;
    double conversion_factor = 1.0;

    // Find the from unit in the array
    while (i < UNIT_CONVERTER_MAX_UNITS && strcmp(units[i].name, from_unit) != 0) {
        i++;
    }

    // If the from unit is not found, return an error
    if (i == UNIT_CONVERTER_MAX_UNITS) {
        printf("Error: Unknown unit %s\n", from_unit);
        return 0;
    }

    // Calculate the conversion factor
    conversion_factor = units[i].conversion_factor;

    // Find the to unit in the array
    i = 0;
    while (i < UNIT_CONVERTER_MAX_UNITS && strcmp(units[i].name, to_unit) != 0) {
        i++;
    }

    // If the to unit is not found, return an error
    if (i == UNIT_CONVERTER_MAX_UNITS) {
        printf("Error: Unknown unit %s\n", to_unit);
        return 0;
    }

    // Return the converted value
    return value * conversion_factor;
}

int main() {
    double value = 5.0;
    char from_unit[] = "meter";
    char to_unit[] = "foot";

    // Convert the value from meters to feet
    double converted_value = convert_unit(value, from_unit, to_unit);

    // Print the converted value
    printf("Value in feet: %f\n", converted_value);

    return 0;
}