//Falcon-180B DATASET v1.0 Category: Color Code Converter ; Style: puzzling
#include <stdio.h>
#include <stdlib.h>

// Function prototypes
void generateRandomColorCode(char* colorCode);
int isValidColorCode(char* colorCode);

int main() {
    char colorCode[7];
    int validCode = 0;

    // Generate a random color code
    generateRandomColorCode(colorCode);

    // Print the color code
    printf("Random color code: %s\n", colorCode);

    // Check if the color code is valid
    validCode = isValidColorCode(colorCode);
    if (validCode == 0) {
        printf("Invalid color code.\n");
    } else {
        printf("Valid color code.\n");
    }

    return 0;
}

// Generates a random color code in the format "#RRGGBB"
void generateRandomColorCode(char* colorCode) {
    int i;
    for (i = 0; i < 6; i++) {
        colorCode[i] = '0' + (rand() % 10);
    }
    colorCode[6] = '\0';
}

// Checks if a color code is valid (in the format "#RRGGBB")
int isValidColorCode(char* colorCode) {
    if (strlen(colorCode)!= 7 || colorCode[0]!= '#') {
        return 0;
    }

    int i;
    for (i = 1; i < 7; i++) {
        if (!isxdigit(colorCode[i])) {
            return 0;
        }
    }

    return 1;
}