//LLAMA2-13B DATASET v1.0 Category: Bitwise operations ; Style: authentic
#include <stdio.h>
#include <stdint.h>

// Define a struct to represent a point on a 2D grid
typedef struct {
    int x: 5;  // x coordinate (5 bits)
    int y: 5;  // y coordinate (5 bits)
} Point;

// Function to print a point in decimal format
void print_point(Point p) {
    printf("%d, %d", p.x, p.y);
}

// Function to print a point in binary format
void print_point_binary(Point p) {
    printf("%d%o", p.x, p.y);
}

// Function to perform bitwise AND operation on two points
Point and_points(Point p1, Point p2) {
    Point result;
    result.x = p1.x & p2.x;
    result.y = p1.y & p2.y;
    return result;
}

// Function to perform bitwise OR operation on two points
Point or_points(Point p1, Point p2) {
    Point result;
    result.x = p1.x | p2.x;
    result.y = p1.y | p2.y;
    return result;
}

// Function to perform bitwise XOR operation on two points
Point xor_points(Point p1, Point p2) {
    Point result;
    result.x = p1.x ^ p2.x;
    result.y = p1.y ^ p2.y;
    return result;
}

int main() {
    // Create two points
    Point p1 = {3, 4};
    Point p2 = {1, 2};

    // Perform bitwise AND operation
    Point result = and_points(p1, p2);
    print_point(result);

    // Perform bitwise OR operation
    result = or_points(p1, p2);
    print_point(result);

    // Perform bitwise XOR operation
    result = xor_points(p1, p2);
    print_point(result);

    return 0;
}