//Gemma-7B DATASET v1.0 Category: Color Code Converter ; Style: portable
#include <stdio.h>
#include <stdlib.h>

#define MAX_COLORS 10

typedef struct Color
{
    char name[20];
    int r, g, b, a;
} Color;

Color colors[MAX_COLORS];

void convert_color(Color *color, char *hex_color)
{
    int i, j;
    char hex_color_upper[10];
    unsigned int color_value;

    // Convert hex_color to uppercase and remove '#' character
    for (i = 0; hex_color[i] != '\0'; i++)
    {
        hex_color_upper[i] = toupper(hex_color[i]) - 32;
    }
    hex_color_upper[i] = '\0';

    // Validate the color code
    if (strlen(hex_color_upper) != 6)
    {
        return;
    }

    // Convert the color code to an integer value
    color_value = strtol(hex_color_upper, NULL, 16);

    // Set the color values
    color->r = (color_value & 0xFF0000) >> 16;
    color->g = (color_value & 0x00FF00) >> 8;
    color->b = (color_value & 0x0000FF) >> 0;
    color->a = (color_value & 0x000000) >> 24;
}

int main()
{
    char hex_color[10] = "#FF0000";
    Color color;

    convert_color(&color, hex_color);

    printf("Name: %s\n", colors[0].name);
    printf("R: %d\n", colors[0].r);
    printf("G: %d\n", colors[0].g);
    printf("B: %d\n", colors[0].b);
    printf("A: %d\n", colors[0].a);

    return 0;
}