//GPT-4o-mini DATASET v1.0 Category: Threading Library Implementation ; Style: ultraprecise
#include <stdio.h>
#include <stdlib.h>
#include <pthread.h>
#include <string.h>
#include <unistd.h>

#define NUM_THREADS 5
#define MAX_BUFFER 256

typedef struct {
    int thread_id;
    char message[MAX_BUFFER];
} thread_data_t;

// Function to be executed by each thread
void* thread_function(void* arg) {
    thread_data_t* data = (thread_data_t*)arg;
    printf("Thread %d: Started with message: %s\n", data->thread_id, data->message);
    
    // Simulating some work
    for (int i = 0; i < 5; i++) {
        printf("Thread %d: Working... (%d)\n", data->thread_id, i);
        sleep(1);  // Sleep for 1 second
    }

    printf("Thread %d: Finished work!\n", data->thread_id);
    pthread_exit(NULL);
}

// Main function
int main() {
    pthread_t threads[NUM_THREADS];
    thread_data_t thread_data[NUM_THREADS];
    int rc;
    
    // Create threads
    for (int i = 0; i < NUM_THREADS; i++) {
        thread_data[i].thread_id = i;
        snprintf(thread_data[i].message, MAX_BUFFER, "Hello from thread %d!", i);
        
        printf("Main: Creating thread %d\n", i);
        rc = pthread_create(&threads[i], NULL, thread_function, (void*)&thread_data[i]);
        
        if (rc) {
            fprintf(stderr, "Error: Unable to create thread %d, %d\n", i, rc);
            exit(EXIT_FAILURE);
        }
    }
    
    // Wait for all threads to complete
    for (int i = 0; i < NUM_THREADS; i++) {
        rc = pthread_join(threads[i], NULL);
        if (rc) {
            fprintf(stderr, "Error: Unable to join thread %d, %d\n", i, rc);
            exit(EXIT_FAILURE);
        }
    }
    
    printf("Main: All threads have completed their work.\n");
    return 0;
}