//Falcon-180B DATASET v1.0 Category: Memory management ; Style: interoperable
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_SIZE 1000

typedef struct {
    int id;
    char name[MAX_SIZE];
    int age;
} Person;

Person* create_person(int id, char* name, int age) {
    Person* person = (Person*) malloc(sizeof(Person));
    if (person == NULL) {
        printf("Error: Memory allocation failed.\n");
        return NULL;
    }

    person->id = id;
    strcpy(person->name, name);
    person->age = age;

    return person;
}

void delete_person(Person* person) {
    if (person!= NULL) {
        free(person);
        person = NULL;
    }
}

void display_person(Person* person) {
    if (person!= NULL) {
        printf("ID: %d\n", person->id);
        printf("Name: %s\n", person->name);
        printf("Age: %d\n", person->age);
    } else {
        printf("Person is NULL.\n");
    }
}

int main() {
    Person* person1 = create_person(1, "John", 25);
    Person* person2 = create_person(2, "Jane", 30);

    display_person(person1);
    display_person(person2);

    delete_person(person1);
    delete_person(person2);

    return 0;
}