//GEMINI-pro DATASET v1.0 Category: Graph Coloring Problem ; Style: accurate
#include <stdio.h>
#include <stdlib.h>

// Number of vertices in the graph
#define V 4

// A utility function to check if the current color assignment
// is safe for vertex v
int isSafe(int v, int graph[V][V], int color[], int c)
{
    for (int i = 0; i < V; i++)
        if (graph[v][i] && c == color[i])
            return 0;
    return 1;
}

// A recursive utility function to solve the m coloring problem
int graphColoring(int graph[V][V], int m, int color[], int v)
{
    // If all vertices are assigned a color then return true
    if (v == V)
        return 1;

    // Consider this vertex v and try different colors
    for (int c = 1; c <= m; c++)
    {
        // Check if assignment of color c to v is safe
        if (isSafe(v, graph, color, c))
        {
            color[v] = c;

            // Recur to assign colors to rest of the vertices
            if (graphColoring(graph, m, color, v + 1))
                return 1;

            // If assigning color c doesn't lead to a solution
            // then remove it
            color[v] = 0;
        }
    }

    // If no color can be assigned to this vertex then return false
    return 0;
}

// Driver code
int main()
{
    /* Create following graph
        (0)--(1)--(2)
        | /  \  \
        | /    \  \
        | /      \  \
        (3)--------(4)
    */
    int graph[V][V] = {{0, 1, 1, 1},
                        {1, 0, 1, 0},
                        {1, 1, 0, 1},
                        {1, 0, 1, 0}};

    // Number of colors
    int m = 3;

    // Create a color array to store the colors assigned to all vertices.
    // Initialize all colors as 0
    int color[V];
    for (int i = 0; i < V; i++)
        color[i] = 0;

    if (graphColoring(graph, m, color, 0) == 0)
    {
        printf("Solution does not exist");
        return 0;
    }

    // Print the solution
    printf("Following are the assigned colors \n");
    for (int i = 0; i < V; i++)
        printf("Vertex %d -> Color %d\n", i, color[i]);

    return 0;
}