//Gemma-7B DATASET v1.0 Category: Chat server ; Style: paranoid
#include <stdio.h>
#include <string.h>
#include <netdb.h>

#define LISTEN_PORT 8080

int main()
{
    int sockfd, newsockfd, portno;
    struct sockaddr_in serv_addr, cli_addr;
    char buffer[1024];
    char *message, *client_ip;

    sockfd = socket(AF_INET, SOCK_STREAM, htons(LISTEN_PORT));
    if (sockfd < 0)
    {
        perror("Error creating socket");
        exit(1);
    }

    serv_addr.sin_family = AF_INET;
    serv_addr.sin_port = htons(LISTEN_PORT);
    serv_addr.sin_addr.s_addr = htonl(INADDR_ANY);

    if (bind(sockfd, (struct sockaddr *)&serv_addr, sizeof(serv_addr)) < 0)
    {
        perror("Error binding socket");
        exit(1);
    }

    listen(sockfd, 1);

    newsockfd = accept(sockfd, (struct sockaddr *)&cli_addr, NULL);
    if (newsockfd < 0)
    {
        perror("Error accepting connection");
        exit(1);
    }

    client_ip = inet_ntoa(cli_addr.sin_addr);
    message = "Enter your message: ";

    write(newsockfd, message, strlen(message));
    read(newsockfd, buffer, 1024);

    printf("Client IP: %s, Message: %s\n", client_ip, buffer);

    close(newsockfd);
    close(sockfd);

    return 0;
}