//Gemma-7B DATASET v1.0 Category: Cafe Billing System ; Style: visionary
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ITEMS 10

typedef struct Item {
    char name[20];
    int quantity;
    float price;
} Item;

Item items[MAX_ITEMS];

void addItem(Item item) {
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] == '\0') {
            items[i] = item;
            return;
        }
    }

    printf("Error: Item list is full.\n");
}

void printItems() {
    printf("Items:\n");
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            printf("%s - %d - %.2f\n", items[i].name, items[i].quantity, items[i].price);
        }
    }
}

void calculateTotal() {
    float total = 0.0f;
    for (int i = 0; i < MAX_ITEMS; i++) {
        if (items[i].name[0] != '\0') {
            total += items[i].quantity * items[i].price;
        }
    }

    printf("Total: %.2f\n", total);
}

int main() {
    Item item1 = {"Coffee", 5, 2.50f};
    addItem(item1);

    Item item2 = {"Tea", 3, 1.75f};
    addItem(item2);

    Item item3 = {"Juice", 2, 1.25f};
    addItem(item3);

    printItems();

    calculateTotal();

    return 0;
}