//Gemma-7B DATASET v1.0 Category: Fitness Tracker ; Style: post-apocalyptic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_READINGS 10

typedef struct Reading
{
    int timestamp;
    int heart_rate;
    int oxygen_level;
} Reading;

Reading readings[MAX_READINGS];

void record_reading(int heart_rate, int oxygen_level)
{
    time_t timestamp = time(NULL);
    readings[0].timestamp = timestamp;
    readings[0].heart_rate = heart_rate;
    readings[0].oxygen_level = oxygen_level;

    for (int i = 1; i < MAX_READINGS; i++)
    {
        readings[i] = readings[i - 1];
    }

    readings[MAX_READINGS - 1].timestamp = timestamp;
    readings[MAX_READINGS - 1].heart_rate = heart_rate;
    readings[MAX_READINGS - 1].oxygen_level = oxygen_level;
}

void analyze_readings()
{
    int average_heart_rate = 0;
    int average_oxygen_level = 0;

    for (int i = 0; i < MAX_READINGS; i++)
    {
        average_heart_rate += readings[i].heart_rate;
        average_oxygen_level += readings[i].oxygen_level;
    }

    average_heart_rate /= MAX_READINGS;
    average_oxygen_level /= MAX_READINGS;

    printf("Average Heart Rate: %d\n", average_heart_rate);
    printf("Average Oxygen Level: %d\n", average_oxygen_level);
}

int main()
{
    record_reading(80, 25);
    record_reading(75, 22);
    record_reading(85, 24);
    record_reading(82, 23);

    analyze_readings();

    return 0;
}