//Falcon-180B DATASET v1.0 Category: Building a HTTP Client ; Style: beginner-friendly
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>
#include <curl/curl.h>

// Function to write the received data to a file
size_t WriteCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    FILE *fp = (FILE *)userp;
    return fwrite(contents, size, nmemb, fp);
}

// Function to handle the response from the server
size_t ResponseCallback(void *contents, size_t size, size_t nmemb, void *userp) {
    char *response = (char *)malloc(size * nmemb + 1);
    memcpy(response, contents, size * nmemb);
    response[size * nmemb] = '\0';
    printf("%s", response);
    free(response);
    return size * nmemb;
}

int main() {
    CURL *curl;
    FILE *fp;
    CURLcode res;

    curl_global_init(CURL_GLOBAL_DEFAULT);

    // Initialize the curl session
    curl = curl_easy_init();

    // Set the URL to fetch
    curl_easy_setopt(curl, CURLOPT_URL, "http://example.com");

    // Set the callback functions
    curl_easy_setopt(curl, CURLOPT_WRITEFUNCTION, WriteCallback);
    curl_easy_setopt(curl, CURLOPT_WRITEDATA, stdout);

    // Perform the request
    res = curl_easy_perform(curl);

    // Check for errors
    if (res!= CURLE_OK)
        fprintf(stderr, "curl_easy_perform() failed: %s\n",
                curl_easy_strerror(res));

    // Cleanup the curl session
    curl_easy_cleanup(curl);

    // Close the curl global session
    curl_global_cleanup();

    return 0;
}