//Falcon-180B DATASET v1.0 Category: Electronic Voting System ; Style: imaginative
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_CANDIDATES 10
#define MAX_VOTERS 1000
#define MAX_NAME_LENGTH 50

typedef struct {
    char name[MAX_NAME_LENGTH];
    int votes;
} candidate_t;

typedef struct {
    char name[MAX_NAME_LENGTH];
    int voted;
} voter_t;

candidate_t candidates[MAX_CANDIDATES];
voter_t voters[MAX_VOTERS];

int num_candidates = 0;
int num_voters = 0;

void add_candidate(char* name) {
    strcpy(candidates[num_candidates].name, name);
    candidates[num_candidates].votes = 0;
    num_candidates++;
}

void add_voter(char* name) {
    strcpy(voters[num_voters].name, name);
    voters[num_voters].voted = 0;
    num_voters++;
}

void vote(char* voter_name, int candidate_index) {
    int i;
    for (i = 0; i < num_voters; i++) {
        if (strcmp(voters[i].name, voter_name) == 0) {
            voters[i].voted = 1;
            candidates[candidate_index].votes++;
            break;
        }
    }
}

void print_results() {
    int i;
    for (i = 0; i < num_candidates; i++) {
        printf("%s: %d votes\n", candidates[i].name, candidates[i].votes);
    }
}

int main() {
    add_candidate("Alice");
    add_candidate("Bob");
    add_candidate("Charlie");

    add_voter("Alice");
    add_voter("Bob");
    add_voter("Charlie");

    vote("Alice", 0);
    vote("Bob", 1);
    vote("Charlie", 2);

    print_results();

    return 0;
}