//Falcon-180B DATASET v1.0 Category: Modern Encryption ; Style: immersive
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define KEY_LENGTH 16
#define BLOCK_SIZE 8

typedef struct {
    char key[KEY_LENGTH];
    int rounds;
} encryption_params;

void generate_key(char *key) {
    for (int i = 0; i < KEY_LENGTH; i++) {
        key[i] = rand() % 26 + 'a';
    }
}

void encrypt_block(char *input, char *output, encryption_params *params) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        output[i] = input[i] ^ (params->key[i % KEY_LENGTH] ^ (params->key[(i + 1) % KEY_LENGTH]));
    }
}

void decrypt_block(char *input, char *output, encryption_params *params) {
    for (int i = 0; i < BLOCK_SIZE; i++) {
        output[i] = input[i] ^ (params->key[(i - 1) % KEY_LENGTH] ^ (params->key[i % KEY_LENGTH]));
    }
}

int main() {
    srand(time(NULL));
    encryption_params params;
    generate_key(params.key);
    params.rounds = rand() % 10 + 1;

    char input[BLOCK_SIZE];
    printf("Enter input (up to %d characters):\n", BLOCK_SIZE - 1);
    fgets(input, BLOCK_SIZE, stdin);
    input[BLOCK_SIZE - 1] = '\0';

    char output[BLOCK_SIZE];
    encrypt_block(input, output, &params);

    printf("Encrypted:\n%s\n", output);

    decrypt_block(output, input, &params);

    printf("Decrypted:\n%s\n", input);

    return 0;
}