//Falcon-180B DATASET v1.0 Category: Image Editor ; Style: retro
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define MAX_ROWS 100
#define MAX_COLS 100
#define MAX_PIXELS 1000

typedef struct {
    int rows;
    int cols;
    int pixels[MAX_PIXELS];
} image;

void create_image(image *img, int rows, int cols) {
    img->rows = rows;
    img->cols = cols;
    memset(img->pixels, 0, sizeof(img->pixels));
}

void set_pixel(image *img, int row, int col, int value) {
    if (row >= 0 && row < img->rows && col >= 0 && col < img->cols) {
        img->pixels[row * img->cols + col] = value;
    }
}

void draw_image(image *img) {
    for (int row = 0; row < img->rows; row++) {
        for (int col = 0; col < img->cols; col++) {
            printf("%d ", img->pixels[row * img->cols + col]);
        }
        printf("\n");
    }
}

int main() {
    image img;
    create_image(&img, 10, 10);

    set_pixel(&img, 0, 0, 1);
    set_pixel(&img, 0, 1, 2);
    set_pixel(&img, 0, 2, 3);
    set_pixel(&img, 0, 3, 4);
    set_pixel(&img, 0, 4, 5);
    set_pixel(&img, 0, 5, 6);
    set_pixel(&img, 0, 6, 7);
    set_pixel(&img, 0, 7, 8);
    set_pixel(&img, 0, 8, 9);
    set_pixel(&img, 0, 9, 10);

    draw_image(&img);

    return 0;
}