//Falcon2-11B DATASET v1.0 Category: Intrusion detection system ; Style: Donald Knuth
#include <stdio.h>
#include <stdlib.h>
#include <sys/types.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>
#include <string.h>

#define PORT 8080
#define BUFSIZE 1024

int main(int argc, char *argv[]) {
    int server_fd, client_fd, addrlen;
    struct sockaddr_in server_addr, client_addr;
    char buffer[BUFSIZE];

    if (argc!= 2) {
        printf("Usage: %s <IP>\n", argv[0]);
        exit(1);
    }

    server_fd = socket(AF_INET, SOCK_STREAM, 0);
    if (server_fd < 0) {
        perror("socket");
        exit(1);
    }

    server_addr.sin_family = AF_INET;
    server_addr.sin_addr.s_addr = inet_addr(argv[1]);
    server_addr.sin_port = htons(PORT);
    if (bind(server_fd, (struct sockaddr *)&server_addr, sizeof(server_addr)) < 0) {
        perror("bind");
        exit(1);
    }

    listen(server_fd, 5);
    if ((client_fd = accept(server_fd, (struct sockaddr *)&client_addr, &addrlen)) < 0) {
        perror("accept");
        exit(1);
    }

    if (recv(client_fd, buffer, BUFSIZE, 0) < 0) {
        perror("recv");
        exit(1);
    }

    if (buffer[0] == 'H' && buffer[1] == 'E' && buffer[2] == 'L' && buffer[3] == 'L' && buffer[4] == 'O') {
        printf("Access granted.\n");
    } else {
        printf("Access denied.\n");
    }

    close(client_fd);
    close(server_fd);

    return 0;
}