//Gemma-7B DATASET v1.0 Category: Terminal Based Game ; Style: energetic
#include <stdio.h>
#include <stdlib.h>
#include <time.h>

#define MAX_ENEMIES 5

typedef struct Enemy {
    int x, y;
    char direction;
    int health;
} Enemy;

Enemy enemies[MAX_ENEMIES];

void initializeEnemies() {
    for (int i = 0; i < MAX_ENEMIES; i++) {
        enemies[i].x = rand() % 10;
        enemies[i].y = rand() % 10;
        enemies[i].direction = rand() % 4;
        enemies[i].health = 3;
    }
}

void moveEnemies() {
    for (int i = 0; i < MAX_ENEMIES; i++) {
        switch (enemies[i].direction) {
            case 0:
                enemies[i].x++;
                break;
            case 1:
                enemies[i].x--;
                break;
            case 2:
                enemies[i].y++;
                break;
            case 3:
                enemies[i].y--;
                break;
        }
    }
}

void checkCollisions() {
    for (int i = 0; i < MAX_ENEMIES; i++) {
        for (int j = 0; j < MAX_ENEMIES; j++) {
            if (i != j && enemies[i].x == enemies[j].x && enemies[i].y == enemies[j].y) {
                enemies[j].health--;
            }
        }
    }
}

int main() {
    initializeEnemies();
    moveEnemies();
    checkCollisions();

    for (int i = 0; i < MAX_ENEMIES; i++) {
        printf("Enemy %d: x = %d, y = %d, health = %d\n", i, enemies[i].x, enemies[i].y, enemies[i].health);
    }

    return 0;
}