//GEMINI-pro DATASET v1.0 Category: TCP/IP Programming ; Style: excited
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <arpa/inet.h>
#include <sys/socket.h>
#include <unistd.h>

int main() {
  // Prepare for socket setup! Get ready to connect!
  int socket_descriptor = socket(AF_INET, SOCK_STREAM, 0);
  if (socket_descriptor == -1) {
    perror("Socket creation failed! Oh no!");
    exit(EXIT_FAILURE);
  }
  
  // Set up the server address - get ready for a thrilling connection!
  struct sockaddr_in server_address;
  memset(&server_address, 0, sizeof(server_address));
  server_address.sin_family = AF_INET;
  server_address.sin_port = htons(8080);
  server_address.sin_addr.s_addr = inet_addr("127.0.0.1");
  
  // Connect to the server - let's get this party started!
  if (connect(socket_descriptor, (struct sockaddr *)&server_address, sizeof(server_address)) == -1) {
    perror("Connection failed! Bummer...");
    exit(EXIT_FAILURE);
  }
  
  // Prepare to send a message - buckle up for some data transfer!
  char message[] = "Hello from the client! I'm so excited to chat!";
  int message_length = strlen(message);
  
  // Send the message - off it goes, carrying our heartfelt words!
  int sent_bytes = send(socket_descriptor, message, message_length, 0);
  if (sent_bytes == -1) {
    perror("Message failed to launch! Oops...");
    exit(EXIT_FAILURE);
  }
  
  // Receive a response from the server - anticipation building!
  char buffer[1024];
  memset(buffer, 0, sizeof(buffer));
  int received_bytes = recv(socket_descriptor, buffer, sizeof(buffer), 0);
  if (received_bytes == -1) {
    perror("Response lost in cyberspace! Darn...");
    exit(EXIT_FAILURE);
  }
  
  // Let's see what the server said - reveal the secrets!
  printf("Received from server: %s\n", buffer);
  
  // Close the connection - time to say our goodbyes!
  close(socket_descriptor);
  
  return EXIT_SUCCESS;
}