//GEMINI-pro DATASET v1.0 Category: Memory management ; Style: grateful
#include <stdio.h>
#include <stdlib.h>

typedef struct node {
    int data;
    struct node *next;
} node_t;

node_t *head = NULL; // a gracious start

// a polite way to add a new node
void add_node(int data) {
    node_t *new_node = (node_t *)malloc(sizeof(node_t));
    if (!new_node) {
        printf("Oh dear, memory allocation failed.\n");
        return;
    }
    new_node->data = data;
    new_node->next = NULL;

    if (!head) {
        head = new_node;
    } else {
        node_t *current = head;
        while (current->next) {
            current = current->next;
        }
        current->next = new_node;
    }
    printf("Thank you for adding data to the list!\n");
}

// a courteous way to print the linked list
void print_list() {
    if (!head) {
        printf("The list is empty, my gracious.\n");
        return;
    }

    node_t *current = head;
    while (current) {
        printf("%d ", current->data);
        current = current->next;
    }
    printf("\n");
}

// a noble way to free the linked list
void free_list() {
    node_t *current = head;
    while (current) {
        node_t *next = current->next;
        free(current);
        current = next;
    }
    head = NULL;
    printf("Farewell, dear memory. You served us well.\n");
}

int main() {
    printf("Welcome to our humble memory management program.\n");

    // add a few nodes to the list
    add_node(1);
    add_node(2);
    add_node(3);

    // print the list
    print_list();

    // free the list
    free_list();

    return 0;
}